<!-- Main content -->
<x-admin.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuOpen>{{ $data['menuOpen'] }} </x-slot:menuOpen>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:page>{{ $data['page'] }}</x-slot:page>
    <x-slot:head>
        <link rel="stylesheet" href="{{ asset('assets/') }}/admin/plugins/summernote/summernote-bs4.min.css">
        <style>
            div.note-editable {
                height: 250px;
            }
        </style>
    </x-slot:head>


    <section class="content">

        <!-- Default box -->
        <div class="row">
            <div class="col-lg-12">
                <x-message></x-message>
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title "><i class="fa fa-database text-primary"></i> Data {{ $data['page'] }}
                        </h3>
                    </div>
                    <form action="{{ route('profil.edit') }}" method="POST">
                        <div class="card-body">
                            @csrf
                            @method('put')
                            <input type="hidden" name="id" value="{{ $m->id }}">
                            <input type="hidden" name="kode" value="{{ $m->kode }}">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>No Telp</label>
                                        <input type="text" name="judul" class="form-control numbers"
                                            placeholder="+62..." required value="{{ $m->judul }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Email</label>
                                        <input type="email" name="isi" class="form-control" placeholder="Email"
                                            required value="{{ $m->isi }}">
                                    </div>
                                </div>
                            </div>


                            <div class="form-group ">
                                <label for="">Alamat</label>
                                <textarea name="link" class="form-control"> {{ $m->link }} </textarea>
                            </div>
                            <div class="form-group ">
                                <label for="">Embed Map (W =100%, H =230px)</label>
                                <textarea name="gambar" class="form-control"> {{ $m->gambar }} </textarea>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="reset" class="btn btn-default"><i class="fa fa-sync-alt"></i>
                                Reset</button>
                            <button class="btn btn-primary float-right"><i class="fa fa-save"></i> Simpan
                                Perubahan</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- /.card -->

    </section>


    <x-slot:foot>
        <script src="{{ asset('assets/') }}/admin/plugins/summernote/summernote-bs4.min.js"></script>
        <script>
            $('#summernote').summernote();
        </script>
    </x-slot:foot>
</x-admin.contents>
